dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

local t_start = 0.0
local t_stop = 0.0

--------------------------------------------------------
-- SLOWED DOWN VERSION
local dt = 0.2		-- Default interval between commands in the stack
local dts = 0.8		-- Variable time

local dt_mto = 5	-- dts 0.2   dt_mto 3       -- dts 0.8          5  

-----------------------------------------------------------

local dt_mto2 = 2	-- Used in APU Start
local dt_mto3 = 3	-- Used in Eng Starts
local rs = 12		-- Rotor Spoolup 
local ad = 10		-- APU Start delay
local le1 = 15		-- L eng to 20
local le2 = 35		-- L eng to 60
local re1 = le1
local re2 = le2
local d1 = dt_mto + 1.5	-- delays
local d2 = dt_mto2 + 2
local d3 = dt_mto3 + 1.5
local d4 = dt_mto

-----------------------------
local td1 = 1
local td2 = 2
local td3 = 3
local td4 = 4
local td5 = 5
local td6 = 6
local td7 = 7
local td8 = 8
local td9 = 9
local td10 = 10
local td11 = 11
local td12 = 12
local td13 = 13
local td14 = 14
local td15 = 15
local td16 = 16
local td17 = 17
local td18 = 18
local td19 = 19
local td20 = 20
local td25 = 25
local td29 = 29

local dt1 = dt * 1
local dt2 = dt * 2
local dt3 = dt * 3
local dt4 = dt * 4
local dt5 = dt * 5
local dt6 = dt * 6
local dt7 = dt * 7
local dt8 = dt * 8
local dt9 = dt * 9
local dt10 = dt * 10
local dt11 = dt * 11
local dt12 = dt * 12
local dt13 = dt * 13
local dt14 = dt * 14
local dt15 = dt * 15
local dt16 = dt * 16
local dt17 = dt * 17
local dt18 = dt * 18
local dt19 = dt * 19
local dt20 = dt * 20
local dt21 = dt * 21
local dt22 = dt * 22
local dt23 = dt * 23
local dt24 = dt * 24
local dt25 = dt * 25
local dt26 = dt * 26
local dt27 = dt * 27
local dt28 = dt * 28
local dt29 = dt * 29
local dt30 = dt * 30
local dt31 = dt * 31
local dt32 = dt * 32
local dt33 = dt * 33
local dt34 = dt * 34
local dt35 = dt * 35
local dt36 = dt * 36
local dt37 = dt * 37
local dt38 = dt * 38
local dt39 = dt * 39
local dt40 = dt * 40
local dt41 = dt * 41
local dt42 = dt * 42
local dt43 = dt * 43
local dt44 = dt * 44
local dt45 = dt * 45
local dt46 = dt * 46
local dt47 = dt * 47
local dt48 = dt * 48
local dt49 = dt * 49
local dt50 = dt * 50
local dt51 = dt * 51
local dt52 = dt * 52
local dt53 = dt * 53
local dt54 = dt * 54
local dt55 = dt * 55
local dt56 = dt * 56
local dt57 = dt * 57
local dt58 = dt * 58
local dt59 = dt * 59
local dt60 = dt * 60

local dts1 = dts * 1
local dts2 = dts * 2
local dts3 = dts * 3
local dts4 = dts * 4
local dts5 = dts * 5
local dts6 = dts * 6
local dts7 = dts * 7
local dts8 = dts * 8
local dts9 = dts * 9
local dts10 = dts * 10
local dts11 = dts * 11
local dts12 = dts * 12
local dts13 = dts * 13
local dts14 = dts * 14
local dts15 = dts * 15
local dts16 = dts * 16
local dts17 = dts * 17
local dts18 = dts * 18
local dts19 = dts * 19
local dts20 = dts * 20
local dts21 = dts * 21
local dts22 = dts * 22
local dts23 = dts * 23
local dts24 = dts * 24
local dts25 = dts * 25
local dts26 = dts * 26
local dts27 = dts * 27
local dts28 = dts * 28
local dts29 = dts * 29
local dts30 = dts * 30
local dts31 = dts * 31
local dts32 = dts * 32
local dts33 = dts * 33
local dts34 = dts * 34
local dts35 = dts * 35
local dts36 = dts * 36
local dts37 = dts * 37
local dts38 = dts * 38
local dts39 = dts * 39
local dts40 = dts * 40
local dts41 = dts * 41
local dts42 = dts * 42
local dts43 = dts * 43
local dts44 = dts * 44
local dts45 = dts * 45
local dts46 = dts * 46
local dts47 = dts * 47
local dts48 = dts * 48
local dts49 = dts * 49
local dts50 = dts * 50
local dts51 = dts * 51
local dts52 = dts * 52
local dts53 = dts * 53
local dts54 = dts * 54
local dts55 = dts * 55
local dts56 = dts * 56
local dts57 = dts * 57
local dts58 = dts * 58
local dts59 = dts * 59
local dts60 = dts * 60
local dts63 = dts * 63
local dts65 = dts * 65
local dts68 = dts * 68
----------------------

local aub1 = dt3 + dt6						-- Autopilot
local wa1 = dts10							-- Weapons / Arm
local cou1 = dt8 + dts7						-- Countermeasures
local tg1 = dt8 + dts9 + rs					-- Throttles, Generators etc
local suaf = aub1 + wa1 + cou1 + tg1 + d3	-- Set Up Airc Flight
local res = dt13 + td3 + re1 + re2 + d3		-- Starting Right Eng
local les = dt14 + td3 + le1 + le2 + d1		-- Starting Left Eng
local paes = dts18 + d2						-- Prepare Airc Eng Start
local apus = dt9 + td3 + ad + d1			-- APU Start
local paas = dts9 + d1						-- Prepare Airc APU Start
local lc = dt10 + dts8						-- Left Console
local fop = dts13							-- Front Overhead Panels
local rbw = dts15 + d1						-- Right Back Wall Panel 
local rc = dts63 + dt1						-- Right Console
local papf = lc + fop + rbw + rc + dts		-- Pre Airc Pre Flight

local sst = papf + paas + apus + paes + les + res + suaf + (1.9 - dt2 - dts) + dt_mto

local abr = 80 - ((dts * 87) + (dt * 11) + d1) + 1	-- +1 offset / 80 sec to startup
local inu = 180 - ((dts * 34) + (dt * 10)) + 1		-- +1 offset / 180 sec to start

--------------------------------------------------------------------------------------------------------------------

start_sequence_full = {}
stop_sequence_full = {}
cockpit_illumination_full = {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] = command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full, t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full, t_stop, command)
end

local count = 0
local function counter()
	count = count + 1
	return count
end




-- NOTES:
-- NOTE: SA-TLF switch has no function in game.

-- "device = " refers to the device name and index number in devices.lua.
-- "action = " refers to the number of the button in clickabledata.lua plus 3000.  So Button_1 in clickabledata.lua is "action = 3001", Button_2 is "action = 3002", etc.  You can use the key name given in command_defs.lua (for instance "action = Keys.iCommand_VMS_ALMAZ_UP_EmergencyOn"), but there is no easy way to connect a key name to a button number as they aren't explicitly linked in the files as is the case with later modules.

-- The above is no longer true.  I updated it to the new format.  Thank you Havoc for including that note.  It was my discovering this note (and some of your other notes) that opened up my first understanding of how actions in these autostarts and missions work. This note and a determination to somehow figure out how to fix your broken startups.  From these I could expand my knowledge and get to where I am now in modifying these.  It all started with this note.  I will always be greatful.  Eccentric_xMD 


-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------


-- Start


push_start_command(dt, {message = _("Eccentric_xMD's Ka_50 v3 Autostart Sequence is Running 3m30s"), message_timeout = sst})

push_start_command(0.8, {message = _("- Check Condition   HAVOC = GOAT"), message_timeout = 1.5})
push_start_command(0.8, {message = _("- CONDITION TRUE"), message_timeout = 0.7})
push_start_command(0.3, {message = _("- Proceeding with Autostart Sequence"), message_timeout = 0.5})


-- Preparing Aircraft Pre-Flight
-- local papf = lc + fop + rbw + rc + dts

push_start_command(dts, {message = _("- Preparing Aircraft Pre-Flight"), message_timeout = dt_mto + papf - (dt10 + dts3)})
-- dt_mto + dts60 + dts32 + d2

----------------------
-- dts 63 	dt1
-- local rc = dts63 + dt1

-- Right Console

push_start_command(dts, {message = _("  - Right Console & Panel"), message_timeout = dt_mto + rc - (dts3 + dt1)}) 


push_start_command(dts, {message = _("     - Battery 1 - On"), message_timeout = dt_mto + dts59})
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_6, value = 0}) -- Cover toggle
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_5, value = 1}) -- Switch
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_6, value = 0}) -- Cover toggle

push_start_command(dts, {message = _("     - Battery 2 - On"), message_timeout = dt_mto + dts55})
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_4, value = 0}) -- Cover toggle
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_3, value = 1}) -- Switch
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_4, value = 0}) -- Cover toggle

push_start_command(dts, {message = _("     - ABRIS Advanced Moving Map System (AMMS) Power - On"), message_timeout = dt_mto + dts51})
push_start_command(dts, {device = devices.ABRIS, action = device_commands.Button_9, value = 1})

push_start_command(dts, {message = _("     - Pilot Vehicle Interface"), message_timeout = dt_mto + dts49})
push_start_command(dts, {message = _("          - PVI-800 Navigation Datalink Power - On"), message_timeout = dt_mto + dts48})
push_start_command(dts, {device = devices.DATALINK, action = device_commands.Button_16, value = 1.0})

push_start_command(dts, {message = _("          - PVI-800 Navigation Master Mode Knob - Operation (OPER)"), message_timeout = dt_mto + dts46})
push_start_command(dts, {device = devices.PVI, action = device_commands.Button_27, value = 0.3}) -- OPER

push_start_command(dts, {message = _("     - Radios & Datalink"), message_timeout = dt_mto + dts44})

push_start_command(dts, {message = _("          - Datalink Master Mode Knob - Commander (COM)"), message_timeout = dt_mto + dts43})
push_start_command(dts, {device = devices.DATALINK, action = device_commands.Button_15, value = 0.3}) -- COM

push_start_command(dts, {message = _("          - Intercom (SPU-9) Power - On"), message_timeout = dt_mto + dts41})
push_start_command(dts, {device = devices.SPU_9, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("          - VHF-1 (R-828) Power - On"), message_timeout = dt_mto +dts39})
push_start_command(dts, {device = devices.R_828, action = device_commands.Button_5, value = 1.0})

push_start_command(dts, {message = _("          - VHF-2 (R-800) Power - On"), message_timeout = dt_mto + dts37})
push_start_command(dts, {device = devices.R_800, action = device_commands.Button_11, value = 1.0})

push_start_command(dts, {message = _("          - Datalink Radio (TLK) Power - On"), message_timeout = dt_mto + dts35})
push_start_command(dts, {device = devices.DATALINK, action = device_commands.Button_17, value = 1.0})

push_start_command(dts, {message = _("          - VHF-TLK power - On"), message_timeout = dt_mto + dts33})
push_start_command(dts, {device = devices.DATALINK, action = device_commands.Button_18, value = 1.0})

push_start_command(dts, {message = _("     - Fuel Gauge Power - On"), message_timeout = dt_mto + dts31})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_5, value = 1.0})

push_start_command(dts, {message = _("     - Ejection System - On"), message_timeout = dt_mto + dts29})
push_start_command(dts, {device = devices.EJECT_SYS_INTERFACE, action = device_commands.Button_4, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.EJECT_SYS_INTERFACE, action = device_commands.Button_1, value = 0.0}) -- Switch 1
push_start_command(dts, {device = devices.EJECT_SYS_INTERFACE, action = device_commands.Button_2, value = 0.0}) -- Switch 2
push_start_command(dts, {device = devices.EJECT_SYS_INTERFACE, action = device_commands.Button_3, value = 0.0}) -- Switch 3
push_start_command(dts, {device = devices.EJECT_SYS_INTERFACE, action = device_commands.Button_4, value = 0.0}) -- Cover close

push_start_command(dts, {message = _("     - Weapons Control System Power - On"), message_timeout = dt_mto + dts23})
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_19, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_18, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_19, value = 0.0}) -- Cover close

push_start_command(dts, {message = _("     - Standby Attitude Indicator (SAI) Power - On"), message_timeout = dt_mto + dts19})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_4, value = 1.0})

push_start_command(dts, {message = _("     - Aircraft External Lights"), message_timeout = dt_mto + dts17})
push_start_command(dts, {message = _("          - Anticollision Beacon - On"), message_timeout = dt_mto + dts16})
push_start_command(dts, {device = devices.NAVLIGHT_SYSTEM, action = device_commands.Button_3, value = 1.0})

push_start_command(dts, {message = _("          - Blade Tip Lights - On"), message_timeout = dt_mto + dts14})
push_start_command(dts, {device = devices.NAVLIGHT_SYSTEM, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("          - Formation Lights - On 100%"), message_timeout = dt_mto + dts12})
push_start_command(dts, {device = devices.NAVLIGHT_SYSTEM, action = device_commands.Button_2, value = 0.3})

push_start_command(dts, {message = _("     - Navigation System Power - On"), message_timeout = dt_mto + dts10})
push_start_command(dts, {device = devices.K041, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("     - Identify Friend or Foe (IFF) Power - On"), message_timeout = dt_mto + dts8})
push_start_command(dts, {device = devices.IFF, action = device_commands.Button_2, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.IFF, action = device_commands.Button_1, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.IFF, action = device_commands.Button_2, value = 0.0}) -- Cover close

push_start_command(dts, {message = _("     - Fire Extinguishers - On"), message_timeout = dt_mto + dts4})
push_start_command(dts, {device = devices.FIRE_EXTING_INTERFACE, action = device_commands.Button_7, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.FIRE_EXTING_INTERFACE, action = device_commands.Button_6, value = 0.2}) -- Switch
push_start_command(dts, {device = devices.FIRE_EXTING_INTERFACE, action = device_commands.Button_7, value = 0.0}) -- Cover close

push_start_command(dts, {message = _("     - Set Radio Selector to 5 - 30.0 FM)"), message_timeout = dt_mto})
push_start_command(dts, {device = devices.R_828, action = device_commands.Button_1, value = 0.4})
push_start_command(dts, {device = devices.R_828, action = device_commands.Button_3, value = 1})
push_start_command(dt, {device = devices.R_828, action = device_commands.Button_3, value = 0})


----------------------
-- d1	dts15
-- local rbw = dts15 + d1

-- Right Back Wall Panel

push_start_command(d1, {message = _("  - Right Back Wall Panel"), message_timeout = dt_mto + rbw + fop + lc - (dts3 + dt10 + d1)})

push_start_command(dts, {message = _("     - Inertial Navigation Unit (INU) Power - On"), message_timeout = dt_mto + dts33})
push_start_command(dts, {device = devices.C061K, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("     - UV-26 Countermeasures Dispenser Power - On"), message_timeout = dt_mto + dts31})
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_12, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_10, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_12, value = 0.0}) -- Cover close


push_start_command(dts, {message = _("     - Voice Message System (Betty) - On"), message_timeout = dt_mto + dts27})
push_start_command(dts, {device = devices.VMS, action = device_commands.Button_4, value = 1.0})

push_start_command(dts, {message = _("     - L-140 Laser Warning System power - On"), message_timeout = dt_mto + dts25})
push_start_command(dts, {device = devices.LASER_WARNING_SYSTEM, action = device_commands.Button_2, value = 1.0})

push_start_command(dts, {message = _("     -                     EKRAN 32-03"), message_timeout = dt_mto + dts23})
push_start_command(dts, {message = _("      Internal Diagnostic Warning and Control System - AUTO BASE"), message_timeout = dt_mto + dts22})
push_start_command(dts, {device = devices.CPT_MECH, action = device_commands.Button_3, value = 1.0}) -- Cover open (starts open on cold start, but force close in case autostart is used again)
push_start_command(dts, {device = devices.CPT_MECH, action = device_commands.Button_2, value = 0.0}) -- Switch
push_start_command(dts, {device = devices.CPT_MECH, action = device_commands.Button_3, value = 0.0}) -- Cover close


----------------------
-- dts 13
-- local fop = dts13

-- Front & Overhead Panels

push_start_command(dts, {message = _("  - Front & Overhead Panels"), message_timeout = dt_mto + dts18})

push_start_command(dts, {message = _("     - Standby Attitude Indicator (SAI) - Uncage and Center"), message_timeout = dt_mto + dts17})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})
push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})

push_start_command(dts, {message = _("     - Voice Message System Emergency On"), message_timeout = dt_mto + dts11})
push_start_command(dts, {device = devices.VMS, action = device_commands.Button_2, value = 1.0})

push_start_command(dts, {message = _("     - Engine Dust Protection - On"), message_timeout = dt_mto + dts9})
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_14, value = 0.0})

push_start_command(dts, {message = _("     - Navigation Lights - On 100%"), message_timeout = dt_mto + dts7}) 
push_start_command(dts, {device = devices.NAVLIGHT_SYSTEM, action = device_commands.Button_4, value = 0.3})


----------------------
-- dt10 dts 8
-- local lc = dt10 + dts8

-- Left Console

push_start_command(dts, {message = _("  - Left Console"), message_timeout = dt_mto + lc - (dts3 + dt10)})


push_start_command(dts, {message = _("     - K-041 Targeting-Navigation System - On"), message_timeout = dt_mto + dts4})
push_start_command(dts, {device = devices.K041, action = device_commands.Button_2, value = 1.0})

push_start_command(dts, {message = _("     - SPU-9 Radio Communicator Set to Ground (Grnd)"), message_timeout = dt_mto + dts2})
push_start_command(dts, {device = devices.SPU_9, action = device_commands.Button_2, value = 1.0})

push_start_command(dts, {message = _("     - Tune R-800 to 250.0 Mhz"), message_timeout = dt_mto})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_8, value = -1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_8, value = -1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_8, value = -1.0})
push_start_command(dt, {device = devices.R_800, action = device_commands.Button_8, value = -1.0})


push_start_command(dts, {message = _("- Waiting for ABRIS AMMS Start Up Sequence to Finish"), message_timeout = abr})
push_start_command(dts, {message = _("- Waiting for INU Alignment - Watch HUD Symbology"), message_timeout = inu})


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d1	dts 9
-- local paas = dts9 + d1

-- Prepare Aircraft for APU Start

push_start_command(d1, {message = _("- Preparing Aircraft for Accessory Power Unit (APU) Start"), message_timeout = dt_mto + paas - dts2 - d1})

push_start_command(dts, {message = _("  - Cockpit Door - Close"), message_timeout = dt_mto + dts6})
push_start_command(dts, {device = devices.CPT_MECH, action = device_commands.Button_18, value = 1})

push_start_command(dts, {message = _("  - Forward Fuel Tank Pump - On"), message_timeout = dt_mto + dts4})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("  - Aft Fuel Tank Pump - On"), message_timeout = dt_mto + dts2})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_2, value = 1.0})

push_start_command(dts, {message = _("  - APU Fuel Shut-Off Valve - On"), message_timeout = dt_mto})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_11, value = 1.0}) -- Cover toggle
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_10, value = 1.0}) -- Switch


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d1	ad	dt 9	3s
-- local apus = dt9 + td3 + ad + d1

-- APU start

push_start_command(d1, {message = _("- Starting APU"), message_timeout = dt_mto2 + apus - d1})

push_start_command(dt, {message = _("  - Engine Start Selector Switch - APU"), message_timeout = dt_mto2})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_8, value = 0.0})

push_start_command(dt, {message = _("  - Pressing Start Button for 3 sec"), message_timeout = dt_mto2 + 3 + dt2})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 1.0}) -- Press
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 0.0}) -- Release
push_start_command(td3, {message = _("  - Release Start Button"), message_timeout = dt_mto2})

push_start_command(dt, {message = _("  - Monitor:"), message_timeout = dt_mto2 + ad + dt3})
push_start_command(dt, {message = _("    - APU Exhaust Gas Temperature (EGT) Stabilized ~600 deg C"), message_timeout = dt_mto2 + ad + dt2})
push_start_command(dt, {message = _("    - APU Oil Pressure Normal Illuminated"), message_timeout = dt_mto2 + ad + dt1})
push_start_command(dt, {message = _("    - APU On Illuminated"), message_timeout = dt_mto2 + ad})

push_start_command(ad, {message = _("  - APU started"), message_timeout = dt_mto2})


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d2	dts 18
-- local paes = dts18 + d2

-- Preparing Aircraft for Engine Start

push_start_command(d2, {message = _("- Preparing Aircraft for Engine Start"), message_timeout = dt_mto + paes - dts3 - d2})

push_start_command(dts, {message = _("  - Rotor Brake - Off"), message_timeout = dt_mto + dts14})
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_11, value = 0.0})

push_start_command(dts, {message = _("  - Left Engine Fuel Shut-Off Switch - On"), message_timeout = dt_mto + dts12})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_7, value = 0.0}) -- Cover toggle
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_6, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_7, value = 0.0}) -- Cover toggle

push_start_command(dts, {message = _("  - Right Engine Fuel Shut-Off Switch - On"), message_timeout = dt_mto + dts8})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_9, value = 0.0}) -- Cover toggle
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_8, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_9, value = 0.0}) -- Cover toggle

push_start_command(dts, {message = _("  - Left Engine Electronic Engine Governor (EEG) - On"), message_timeout = dt_mto + dts4})
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_2, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_1, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_2, value = 0.0}) -- Cover close

push_start_command(dts, {message = _("  - Right Engine Electronic Engine Governor (EEG) - On"), message_timeout = dt_mto})
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_4, value = 1.0}) -- Cover open
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_3, value = 1.0}) -- Switch
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_4, value = 0.0}) -- Cover close


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d1	le1	le2	dt 14	td3
-- local les = dt14 + td3 + le1 + le2 + d1

-- Left engine start

push_start_command(d1, {message = _("- Starting Left Engine"), message_timeout = dt_mto3 + les - d1})  --  2.8
-- dt_mto3 + le1 + le2 + dt14 + 3
push_start_command(dt, {message = _("  - Engine Start Selector Switch - Left Engine"), message_timeout = dt_mto3})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_8, value = 0.1})

push_start_command(dt, {message = _("  - Pressing Start Button for 3 sec"), message_timeout = dt_mto3 + 3 + dt2})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 1.0}) -- Press
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 0.0}) -- Release
push_start_command(td3, {message = _("  - Release Start Button"), message_timeout = dt_mto3})

push_start_command(dt, {message = _("  - Monitor:"), message_timeout = dt_mto3 + le1 + le2 + dt8})
push_start_command(dt, {message = _("    - NGG %RPM (Gas Generator Turbine/Compressor Speed"), message_timeout = dt_mto3 + le1 + le2 + dt7})
push_start_command(dt, {message = _("    - Left Engine Oil Pressure"), message_timeout = dt_mto3 + le1 + le2 + dt6})
push_start_command(dt, {message = _("    - Left Engine Oil Temperature"), message_timeout = dt_mto3 + le1 + le2 + 1})
push_start_command(dt, {message = _("    - Transmission Gearbox Oil Pressure"), message_timeout = dt_mto3 + le1 + le2 + dt4})

push_start_command(le1, {message = _("  - Left Engine NGG %RPM 20% : Fuel Cut-Off Valve - Open"), message_timeout = dt_mto3})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_9, value = 1.0})

push_start_command(le2, {message = _("  - Left Engine NGG %RPM > 60%"), message_timeout = dt_mto3 + dt3})
push_start_command(dt, {message = _("  - Start Light Off"), message_timeout = dt_mto3 + dt2})
push_start_command(dt, {message = _("  - Left Engine - Started"), message_timeout = dt_mto3 + dt1})

push_start_command(dt, {message = _("  - Ready for Right Engine Start"), message_timeout = dt_mto3})


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d3	re1	re2	dt 13	td3
-- local res = dt13 + td3 + re1 + re2 + d3

-- Right engine start

push_start_command(d3, {message = _("- Starting Right Engine"), message_timeout = dt_mto3 + res - d3})  --  2.6
-- dt_mto3 + re1 + re2 + dt13 + 3
push_start_command(dt, {message = _("  - Engine Start Selector Switch - Right Engine"), message_timeout = dt_mto})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_8, value = 0.2})

push_start_command(dt, {message = _("  - Pressing Start Button for 3 sec"), message_timeout = dt_mto3 + 3 + dt2})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 1.0}) -- Press
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_5, value = 0.0}) -- Release
push_start_command(td3, {message = _("  - Release Start Button"), message_timeout = dt_mto3})

push_start_command(dt, {message = _("  - Monitor:"), message_timeout = dt_mto3 + re1 + re2 + dt7})
push_start_command(dt, {message = _("    - NGG %RPM (Gas Generator Turbine/Compressor Speed"), message_timeout = dt_mto3 + re1 + re2 + dt6})
push_start_command(dt, {message = _("    - Right Engine Oil Pressure"), message_timeout = dt_mto3 + re1 + re2 + dt5})
push_start_command(dt, {message = _("    - Right Engine Oil Temperature"), message_timeout = dt_mto3 + re1 + re2 + dt4})
push_start_command(dt, {message = _("    - Transmission Gearbox Oil Pressure"), message_timeout = dt_mto3 + re1 + re2 + dt3})

push_start_command(re1, {message = _("  - Right Engine NGG %RPM 20%: Fuel Cut-Off Valve - Open"), message_timeout = dt_mto3})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_10, value = 1.0})

push_start_command(re2, {message = _("  - Right Engine NGG %RPM > 60%"), message_timeout = dt_mto3 + dt2})
push_start_command(dt, {message = _("  - Start Light Off"), message_timeout = dt_mto3 + dt1})

push_start_command(dt, {message = _("  - Right Engine - Started"), message_timeout = dt_mto3})


----------------------------------------------------------------------------------------------------------------------------------------------------------
-- d3
-- local suaf = aub1 + wa1 + cou1 + tg1 + d3

-- Setting Up Aircraft for Flight

push_start_command(d3, {message = _("-- Setting Up Aircraft for Flight --"), message_timeout =  dt_mto + suaf - (dts1 + dt1 + d3)})
-- dt_mto + dts31 + dt19 + rs
-- Throttles/Gen/APU stop etc
-- d3	dts 9	dt 8	rs
-- local tg1 = dt8 + dts9 + rs

push_start_command(dt, {message = _("  - Left and Right Throttles - Auto"), message_timeout = dt_mto + dts31 + dt17 + rs})
push_start_command(dt, {action = 66}) -- NOTE: No device, and I'm not sure where the action is defined, but this does work.
push_start_command(dt, {action = 66}) -- Needs two "presses" to get to Auto.

push_start_command(dt, {message = _("    - Monitor Main Rotor RPM and Engine RPM"), message_timeout = dt_mto + dts31 + dt14 + rs})

push_start_command(dt, {message = _("    - Low Rotor RPM Warning - Off"), message_timeout = dt_mto + dts31 + dt13 + rs})
push_start_command(dt, {device = devices.SYST_CONTROLLER, action = device_commands.Button_3, value = 1.0})
push_start_command(dt, {device = devices.SYST_CONTROLLER, action = device_commands.Button_3, value = 0.0})

push_start_command(rs, {message = _("  - Engines and Rotors RPMs Stabilized"), message_timeout = dt_mto + dts31 + dt11})

push_start_command(dts, {message = _("  - APU - Stop"), message_timeout = dt_mto + dts30 + dt11})
push_start_command(dts, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_7, value = 1.0})
push_start_command(dt, {device = devices.ENGINE_INTERFACE, action = device_commands.Button_7, value = 0.0})

push_start_command(dts, {message = _("  - APU Fuel Shut-Off Valve - Off"), message_timeout = dt_mto + dts28 + dt10})
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_10, value = 0.0}) -- Switch
push_start_command(dts, {device = devices.FUELSYS_INTERFACE, action = device_commands.Button_11, value = 0.0}) -- Cover toggle

push_start_command(dts, {message = _("  - Left AC Generator - On"), message_timeout = dt_mto + dts25 + dt10})
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_8, value = 1.0})

push_start_command(dts, {message = _("  - Right AC Generator - On"), message_timeout = dt_mto + dts23 + dt10})
push_start_command(dts, {device = devices.ELEC_INTERFACE, action = device_commands.Button_9, value = 1.0})

----------------------
-- dt 8		dts 7
-- local cou1 = dt8 + dts7

-- Countermeasures 

push_start_command(dts, {message = _("  - UV-26 Dispenser - Both Sides"), message_timeout = dt_mto + dts21 + dt10})
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_1, value = 0.1}) -- Switch to middle

push_start_command(dts, {message = _("  - UV-26 Program - Reset (to default program 110)"), message_timeout = dt_mto + dts19 + dt10})
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_8, value = 1.0}) -- Press
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_8, value = 0.0}) -- Release

push_start_command(dts, {message = _("  - UV-26 Number of Sequences - 4"), message_timeout = dt_mto + dts17 + dt9})
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 1.0}) -- Press
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 0.0}) -- Release
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 1.0}) -- Press
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 0.0}) -- Release
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 1.0}) -- Press
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_4, value = 0.0}) -- Release

push_start_command(dts, {message = _("  - UV-26 Dispense Interval - 1 SEC"), message_timeout = dt_mto + dts16 + dt3})
push_start_command(dts, {device = devices.UV_26, action = device_commands.Button_6, value = 1.0}) -- Press
push_start_command(dt, {device = devices.UV_26, action = device_commands.Button_6, value = 0.0}) -- Release

----------------------
-- dts 10
-- local wa1 = dts10

-- Weapons / Arm

push_start_command(dts, {message = _("  - Laser Rangefinder - Arm"), message_timeout = dt_mto + dts14 + dt2})
push_start_command(dts, {device = LASERRANGER, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("  - Master Arm - Arm"), message_timeout = dt_mto + dts12 + dt2})
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_1, value = 1.0})

push_start_command(dts, {message = _("  - Man/Auto Weapon - Man"), message_timeout = dt_mto + dts10 + dt2})
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_5, value = 1.0})

push_start_command(dts, {message = _("  - Cannon Round Selector - Armor Piercing (AP)"), message_timeout = dt_mto + dts8 + dt2})
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_6, value = 0})

push_start_command(dts, {message = _("  - Cannon Rate of Fire - Low"), message_timeout = dt_mto + dts6 + dt2})
push_start_command(dts, {device = devices.WEAP_INTERFACE, action = device_commands.Button_20, value = 1.0})

----------------------
-- dt 3		dts 6
-- local aub1 = dt3 + dt6

-- Autopilot buttons

push_start_command(dts, {message = _("  - Autopilot Bank Hold - On"), message_timeout = dt_mto + dts4 + dt2})
push_start_command(dts, {device = devices.AUTOPILOT, action = device_commands.Button_1, value = 1.0})
push_start_command(dt, {device = devices.AUTOPILOT, action = device_commands.Button_1, value = 0.0})

push_start_command(dts, {message = _("  - Autopilot Pitch Hold - On"), message_timeout = dt_mto + dts2 + dt1})
push_start_command(dts, {device = devices.AUTOPILOT, action = device_commands.Button_3, value = 1.0})
push_start_command(dt, {device = devices.AUTOPILOT, action = device_commands.Button_3, value = 0.0})

push_start_command(dts, {message = _("  - Autopilot Heading Hold - On"), message_timeout = dt_mto})
push_start_command(dts, {device = devices.AUTOPILOT, action = device_commands.Button_2, value = 1.0})
push_start_command(dt, {device = devices.AUTOPILOT, action = device_commands.Button_2, value = 0.0})

----------------------


-- Finish

push_start_command(d4, {message = _("Eccentric_xMD's Ka_50_3 Autostart Sequence"), message_timeout = 10})

push_start_command(dt, {message = _("            ----Complete----"), message_timeout = 10})

push_start_command(3, {message = _("Safe Flying and Happy Hunting"), message_timeout = 7})


----------------------------------------------------------------------------------------------------------------------------------------------------------


-- Unused Commands 

-- push_start_command(dt, {message = _("Manual steps remaining:"), message_timeout = 60})

-- push_start_command(dt, {message = _("Radios ... As needed"), message_timeout = 60})

-- push_start_command(dt, {message = _("Baro altitude ... As needed"), message_timeout = 60})

-- push_start_command(dt, {message = _("Unguided weapon pylon ballistic knob (middle knob on right rear wall) ... As needed (see manual p.169 or Chuck's p.126)"), message_timeout = 60})

-- push_start_command(dt, {message = _("Lights ... As needed"), message_timeout = 60})

-- push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.09})
-- push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = -0.03})
-- push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = 0.03})
-- push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = 0.03})
-- push_start_command(dts, {device = devices.STBY_ADI, action = device_commands.Button_3, value = 0.03})

-- push_start_command(dts, {message = _("Master Caution - Off"), message_timeout = dt_mto})
-- push_start_command(dts, {device = devices.SYST_CONTROLLER, action = device_commands.Button_1, value = 1.0})
-- push_start_command(dts, {device = devices.SYST_CONTROLLER, action = device_commands.Button_1, value = 0.0})

-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3004, value = 0.0}) -- Cover toggle
-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3003, value = 1.0}) -- Switch
-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3004, value = 0.0}) -- Cover toggle

-- push_start_command(dts, {device = devices.PVI, action = 3027, value = 0.3}) -- OPER

-- push_start_command(dts, {action = 71}) -- NOTE: No device, and I'm not sure where the action is defined, but this does work.

-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3006, value = 0.0}) -- Cover toggle
-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3005, value = 1.0}) -- Switch
-- push_start_command(dts, {device = devices.ELEC_INTERFACE, action = 3006, value = 0.0}) -- Cover toggle

-- PVI NAV master mode knob - On
-- push_start_command(dt, {device = devices.PVI, action = 3027, value = 0.0}) -- OFF
-- push_start_command(dt, {device = devices.PVI, action = 3027, value = 0.1}) -- CHECK
-- push_start_command(dt, {device = devices.PVI, action = 3027, value = 0.2}) -- ENT

-- Datalink master mode knob - WINGM
-- push_start_command(dt, {device = devices.DATALINK, action = 3015, value = 0.0}) -- OFF
-- push_start_command(dt, {device = devices.DATALINK, action = 3015, value = 0.1}) -- REC
-- push_start_command(dt, {device = devices.DATALINK, action = 3015, value = 0.2}) -- WINGM

-- Lights
-- push_start_command(dt, {message = _("Formation lights - "), message_timeout = dt_mto})
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3002, value = 0.0}) -- Off (center switch position)
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3002, value = 0.1}) -- 10%
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3002, value = 0.2}) -- 30%
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3002, value = 0.3}) -- 100%

-- push_start_command(dt, {message = _("Nav lights - On"), message_timeout = dt_mto}) -- Front upper canopy frame, left side
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3004, value = 0.0}) -- Off (center switch position)
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3004, value = 0.1}) -- 10%
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3004, value = 0.2}) -- 30%
-- push_start_command(dt, {device = devices.NAVLIGHT_SYSTEM, action = 3004, value = 0.3}) -- 100%

-- push_start_command(dts, {message = _("MAKE SURE YOUR COLLECTIVE IS FULLY DOWN!"), message_timeout = 30})

-- local apu_start_time = 20
-- local left_engine_start_time = 40
-- local right_engine_start_time = 50
-- local start_sequence_time = 2 * 60 + 45 -- Startup time
--local stop_sequence_time = 10.0 -- TODO: timeout


-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------


push_stop_command(dt, {message = ("Eccentric_xMD's HAVOC'S QUICK AUTOSTOP SEQUENCE IS RUNNING (0m43s)"), message_timeout = 43})

push_stop_command(dt, {message = _("Laser rangefinder - Safe"), message_timeout = dt_mto})
push_stop_command(dt, {device = LASERRANGER, action = 3001, value = 0.0})
push_stop_command(dt, {message = _("Master Arm - Safe"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.WEAP_INTERFACE, action = 3001, value = 0.0})
push_stop_command(dt, {message = _("Man/Auto weapon - Auto"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.WEAP_INTERFACE, action = 3005, value = 0.0})

push_stop_command(dt, {message = _("SAI - Cage"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.STBY_ADI, action = 3002, value = -1.0})
push_stop_command(dt, {device = devices.STBY_ADI, action = 3003, value = 0.09})
push_stop_command(dt, {device = devices.STBY_ADI, action = 3002, value = 0.0})

push_stop_command(dt, {message = _("IFF power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.IFF, action = 3002, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.IFF, action = 3001, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.IFF, action = 3002, value = 0.0}) -- Cover close

push_stop_command(dt, {message = _("Weapons control system power - Off"), message_timeout = dt_mto}) -- Right wall lower row, next to ejection system switches
push_stop_command(dt, {device = devices.WEAP_INTERFACE, action = 3019, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.WEAP_INTERFACE, action = 3018, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.WEAP_INTERFACE, action = 3019, value = 0.0}) -- Cover close

push_stop_command(dt, {message = _("Ejection system - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.EJECT_SYS_INTERFACE, action = 3004, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.EJECT_SYS_INTERFACE, action = 3001, value = 1.0}) -- Switch 1
push_stop_command(dt, {device = devices.EJECT_SYS_INTERFACE, action = 3002, value = 1.0}) -- Switch 2
push_stop_command(dt, {device = devices.EJECT_SYS_INTERFACE, action = 3003, value = 1.0}) -- Switch 3
push_stop_command(dt, {device = devices.EJECT_SYS_INTERFACE, action = 3004, value = 0.0}) -- Cover close

push_stop_command(dt, {message = _("Datalink master mode knob - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.DATALINK, action = 3015, value = 0.0}) -- OFF
push_stop_command(dt, {message = _("PVI NAV datalink power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.DATALINK, action = 3016, value = 0.0})
push_stop_command(dt, {message = _("PVI NAV master mode knob - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.PVI, action = 3027, value = 0.0}) -- OFF

-- Engine shutdown
push_stop_command(dt, {message = _("Left AC generator - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3008, value = 0.0})
push_stop_command(dt, {message = _("Right AC generator - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3009, value = 0.0})

push_stop_command(dt, {message = _("Left and right throttles - Idle (10s)"), message_timeout = 10})
push_stop_command(dt, {action = 67}) -- NOTE: No device, and I'm not sure where the action is defined, but this does work.
push_stop_command(dt, {action = 67}) -- Needs two "presses" to get to Auto.
push_stop_command(10.0, {message = _("Engines - spooled down"), message_timeout = dt_mto})

push_stop_command(dt, {message = _("Right engine cut-off valve - Close"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3010, value = 0.0})
push_stop_command(dt, {message = _("Right engine EEG - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3004, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3003, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3004, value = 0.0}) -- Cover close
push_stop_command(dt, {message = _("Right engine fuel shut-off switch - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3009, value = 0.0}) -- Cover toggle
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3008, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3009, value = 0.0}) -- Cover toggle

push_stop_command(dt, {message = _("Left engine cut-off valve - Close"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3009, value = 0.0})
push_stop_command(dt, {message = _("Left engine EEG - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3002, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3001, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3002, value = 0.0}) -- Cover close
push_stop_command(dt, {message = _("Left engine fuel shut-off switch - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3007, value = 0.0}) -- Cover toggle
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3006, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3007, value = 0.0}) -- Cover toggle

push_stop_command(dt, {message = _("Forward fuel tank pump - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3001, value = 0.0})
push_stop_command(dt, {message = _("Aft fuel tank pump - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3002, value = 0.0})

push_stop_command(dt, {message = _("K-041 targeting-navigation system power - Off"), message_timeout = dt_mto}) -- Left console in front of collective
push_stop_command(dt, {device = devices.K041, action = 3002, value = 0.0})
push_stop_command(dt, {message = _("EKRAN HYD TRANS PWR switch - Off"), message_timeout = dt_mto}) -- Right rear wall, black guarded switch
push_stop_command(dt, {device = devices.CPT_MECH, action = 3003, value = 1.0}) -- Cover open (starts open on cold start, but force close in case autostart is used again)
push_stop_command(dt, {device = devices.CPT_MECH, action = 3002, value = 1.0}) -- Switch
push_stop_command(dt, {device = devices.CPT_MECH, action = 3003, value = 0.0}) -- Cover close
push_stop_command(dt, {message = _("INU power - Off"), message_timeout = dt_mto}) -- Right rear wall
push_stop_command(dt, {device = devices.C061K, action = 3001, value = 0.0})
push_stop_command(dt, {message = _("UV-26 countermeasures dispenser (CMD) power - Off"), message_timeout = dt_mto}) -- Right rear wall, black guarded switch
push_stop_command(dt, {device = devices.UV_26, action = 3012, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.UV_26, action = 3010, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.UV_26, action = 3012, value = 0.0}) -- Cover close
push_stop_command(dt, {message = _("L-140 laser warning (LWS) power - Off"), message_timeout = dt_mto}) -- Right rear wall
push_stop_command(dt, {device = devices.LASER_WARNING_SYSTEM, action = 3002, value = 0.0})
push_stop_command(dt, {message = _("SAI power - Off"), message_timeout = dt_mto}) -- Right wall
push_stop_command(dt, {device = devices.STBY_ADI, action = 3004, value = 0.0})
push_stop_command(dt, {message = _("Fire extinguishers - Off"), message_timeout = dt_mto}) -- Right wall upper row, black guarded switch
push_stop_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = 3007, value = 1.0}) -- Cover open
push_stop_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = 3006, value = 0.1}) -- Switch
push_stop_command(dt, {device = devices.FIRE_EXTING_INTERFACE, action = 3007, value = 0.0}) -- Cover close

-- Right wall radio switches:
push_stop_command(dt, {message = _("Fuel gauge power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.FUELSYS_INTERFACE, action = 3005, value = 0.0})
push_stop_command(dt, {message = _("Intercom (SPU-9) power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.SPU_9, action = 3001, value = 0.0})
push_stop_command(dt, {message = _("VHF-1 (R-828) power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.R_828, action = 3005, value = 0.0})
push_stop_command(dt, {message = _("VHF-2 (R-800) power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.R_800, action = 3011, value = 0.0})
push_stop_command(dt, {message = _("Datalink radio (TLK) power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.DATALINK, action = 3017, value = 0.0})
push_stop_command(dt, {message = _("VHF-TLK power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.DATALINK, action = 3018, value = 0.0})
-- NOTE: SA-TLF switch has no function in game.

-- ABRIS power
push_stop_command(dt, {message = _("ABRIS power - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ABRIS, action = 3009, value = 0.0})

push_stop_command(dt, {message = _("Battery 1 - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3006, value = 0.0}) -- Cover toggle
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3005, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3006, value = 0.0}) -- Cover toggle
push_stop_command(dt, {message = _("Battery 2 - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3004, value = 0.0}) -- Cover toggle
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3003, value = 0.0}) -- Switch
push_stop_command(dt, {device = devices.ELEC_INTERFACE, action = 3004, value = 0.0}) -- Cover toggle

push_stop_command(dt, {message = _("Voice message system (Betty) - Off"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.VMS, action = 3002, value = 0.0})

-- Wait for the rotor speed to decrease
push_stop_command(dt, {message = _("Wait for rotor to slow to 30%"), message_timeout = dt_mto})
push_stop_command(10, {message = _("Rotor at 30%: rotor brake - On"), message_timeout = dt_mto})
push_stop_command(dt, {device = devices.ENGINE_INTERFACE, action = 3011, value = 0.0})

push_stop_command(dt, {message = _("Cockpit door - Open"), message_timeout = dt_mto})
push_stop_command(dt, {action = 71, value  = 0.0}) -- NOTE: No device, and I'm not sure where the action is defined, but this does work.

push_stop_command(dt, {message = ("Eccentric_xMD's Copy of HAVOC'S QUICK AUTOSTOP COMPLETE"), message_timeout = 60.0})
